import logging

import requests

from advisor_money.settings import HASOFFERS_URL, HASOFFERS_API_TOKEN

logger = logging.getLogger(__name__)


class HasOffersAPI(object):

    def __init__(self):
        self.session = requests.session()

    def _request_hasoffers_api(self, params):
        url = HASOFFERS_URL.format(HASOFFERS_API_TOKEN)
        response = self.session.get(url, params=params, allow_redirects=False)
        response.raise_for_status()

        content = response.json()['response']
        if content.get('errorMessage'):
            logger.warning(content['errorMessage'])
        return content['data']

    def get_click_logs_filenames(self, date):
        params = {
            'Target': 'RawLog',
            'Method': 'listLogs',
            'log_type': 'clicks',
            'date_dir': date.strftime('%Y%m%d'),
        }
        res = self._request_hasoffers_api(params)
        return [item['filename'] for item in res['logFiles']]

    def download_click_log_file(self, filename):
        params = {
            'Target': 'RawLog',
            'Method': 'getDownloadLink',
            'log_type': 'clicks',
            'log_filename': filename,
        }
        res = self._request_hasoffers_api(params)
        download_link = res['link']
        raw_file = self.session.get(download_link).content
        return raw_file

    def get_conversion_by_transaction_id(self, transaction_id):
        params = {
            'Target': 'Conversion',
            'Method': 'findById',
            'transaction_id': transaction_id,
        }
        res = self._request_hasoffers_api(params)
        if res is not None:
            return res['Conversion']
        return res
