import sys


class IpRegLookup(object):
    _lookup = None

    @property
    def lookup(self):
        if self._lookup is None:
            sys.path.append('./modules')
            sys.path.append('./tmpfs_modules')

            from ipreg import lookup
            self._lookup = lookup('layout.json')
        return self._lookup

    def is_yandex_ip(self, ip):
        # noinspection PyBroadException
        try:
            return self.lookup.get_net(ip).is_yandex
        except:
            return False