import os
import yenv
import yt.wrapper as yt
from pymongo.read_preferences import Secondary, Nearest, PrimaryPreferred

BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

YT_TOKEN = os.environ.get('YT_TOKEN')
YT_PROXY = 'hahn.yt.yandex.net'
YT_POOL = 'advisor'

YT_ROOT = yenv.choose_key_by_type({
    'production': '//home/advisor',
    'testing': '//home/advisor/testing',
    'development': '//home/advisor/%s/' % os.environ['USER'] if os.environ.get('USER') else '//home/advisor/testing',
}, fallback=False)

YT_ADVISOR_TMP = '//home/advisor/tmp'

YT_ADDITIONAL_FILES = (
    '/usr/lib/python2.7/dist-packages/ipreg.so',
    '/usr/lib/libipreg.so.1',
    '/usr/lib/x86_64-linux-gnu/libboost_python-py27.so.1.54.0',
    '/usr/lib/libjsoncpp.so.0',
    '/var/cache/geobase/layout.json',
    (os.path.join(os.path.dirname(__file__), 'settings.py'), 'advisor_money/settings.py'),
    (os.path.join(os.path.dirname(__file__), 'default_settings.py'), 'advisor_money/default_settings.py'),
)

YT_CONFIG = {
    'proxy': {'url': YT_PROXY},
    'token': YT_TOKEN,
    'pool': YT_POOL,
    'force_using_yson_for_formatted_requests': False,
    'pickling': {
        'additional_files_to_archive': []
    },
    'spec_defaults': {
        'mapper': {
            'environment': {
                'LD_LIBRARY_PATH': './modules:./tmpfs/modules'
            }
        },
    }
}

for path in YT_ADDITIONAL_FILES:
    if os.path.exists(path[0] if isinstance(path, tuple) else path):
        if isinstance(path, tuple):
            YT_CONFIG['pickling']['additional_files_to_archive'].append(path)
        else:
            YT_CONFIG['pickling']['additional_files_to_archive'].append((path, os.path.basename(path)))

mongodb_uri_template = 'mongodb://{user}:{password}@{hosts}/{database}'

MONGO_USER = os.environ.get('MONGO_USER')
MONGO_PASSWORD = os.environ.get('MONGO_PASSWORD')
MONGO_HOSTS = yenv.choose_key_by_type({
    'production': [
        'localhost',
    ],
    'testing': [
        'sas-m6ed1vwh01lxm0td.db.yandex.net:27018',
        'vla-5xqt1wmnesk3vqto.db.yandex.net:27018',
    ],
}, fallback=True)

MONGO_REPLICA_PASSWORD = os.environ.get('MONGO_REPLICA_PASSWORD')
MONGO_REPLICA_HOSTS = [
    'mrs01h-replica.dev.phone.yandex.net:27018'
]

# jafar db (specific to this project)
JAFAR_MONGO_DB_NAME = 'jafar_db'
JAFAR_MONGO_URI = mongodb_uri_template.format(
    user=MONGO_USER,
    password=MONGO_PASSWORD,
    hosts=','.join(MONGO_HOSTS),
    database=JAFAR_MONGO_DB_NAME,
)
JAFAR_MONGO_READ_PREFERENCE = PrimaryPreferred()

# advisor db (general app recommender databaset with user and app info)
ADVISOR_MONGO_DB_NAME = 'advisor_db'
ADVISOR_MONGO_URI = mongodb_uri_template.format(
    user=MONGO_USER,
    password=MONGO_PASSWORD,
    hosts=','.join(MONGO_HOSTS),
    database=ADVISOR_MONGO_DB_NAME,
)

ADVISOR_MONGO_READ_PREFERENCE = Nearest()

# advisor's replica
ADVISOR_MONGO_REPLICA_DB_NAME = 'advisor_db'
ADVISOR_MONGO_REPLICA_URI = mongodb_uri_template.format(
    user=MONGO_USER,
    password=MONGO_REPLICA_PASSWORD,
    hosts=','.join(MONGO_REPLICA_HOSTS),
    database=ADVISOR_MONGO_REPLICA_DB_NAME,
)
ADVISOR_MONGO_REPLICA_READ_PREFERENCE = Secondary(tag_sets=[{"use": "replica"}])

LOG_USER_PREFIX = os.path.expanduser('~/tmp')

LOG_FORMAT = '[%(asctime)s] [%(process)d] [%(levelname)s] [%(name)s] %(message)s'
LOG_DATEFMT = '%Y-%m-%d %H:%M:%S'


LOGGING = {
    'version': 1,
    'formatters': {
        'default': {
            'format': LOG_FORMAT,
            'datefmt': LOG_DATEFMT,
            'class': 'logging.Formatter',
        },
        'json': {
            '()': 'ylog.format.QloudJsonFormatter'
        }
    },
    'handlers': {
        'qloud': {
            'class': 'logging.StreamHandler',
            'formatter': 'json',
        },
        'console': {
            'level': 'DEBUG',
            'class': 'logging.StreamHandler',
            'formatter': 'default',
        },
        'sentry': {
            'level': 'WARNING',
            'class': 'raven.handlers.logging.SentryHandler',
            'dsn': yenv.choose_key_by_type({
                'production': 'https://6246c9043f30424a90ca76851e9c624a:477b2e7947db4fe2b86cd4526874a008'
                              '@sentry.phone.yandex.net/70?verify_ssl=0',
                'testing': 'https://4aadb20bd98848fb925b75c84b4be897:7260bc5b57c34acd936faa03d596caef'
                           '@sentry.phone.yandex.net/71?verify_ssl=0',
            }, fallback=True),
        }
    },
    'root': {
        'level': 'DEBUG',
        'handlers': yenv.choose_key_by_type({
            'production': ['qloud', 'sentry'],
            'development': ['console'],
        }, fallback=True)
    },
    'loggers': {
        'yt': {
            'level': 'WARNING',
            'handlers': ['qloud'],
        },
        'advisor_money.scripts': {
            'level': yenv.choose_key_by_type({
                'production': 'INFO',
                'development': 'DEBUG',
            }, fallback=True),
            'handlers': yenv.choose_key_by_type({
                'production': ['qloud', 'sentry'],
                'development': ['console'],
            }, fallback=True),
            'propagate': False,
        },
        'nile': {
            'level': 'INFO',
        },
        'qb2': {
            'level': 'INFO',
        }
    }
}

YT_LOGGING = {
    'version': 1,
    'formatters': {
        'default': {
            'format': LOG_FORMAT,
            'datefmt': LOG_DATEFMT,
            'class': 'logging.Formatter',
        }
    },
    'root': {
        'level': 'INFO',
        'handlers': ['console'],
    },
    'handlers': {
        'console': {
            'level': 'DEBUG',
            'class': 'logging.StreamHandler',
            'formatter': 'default',
        },
    }
}

ZOOKEEPER_HOST = ','.join([
    'zuke01e.phone.yandex.net:2181',
    'zuke01i.phone.yandex.net:2181',
    'zuke01h.phone.yandex.net:2181'
])

ISO_DATE_FORMAT = "%Y-%m-%d"

ADVISOR_ACCESS_LOG_1_DAY = '//home/logfeller/logs/advisor-access-log/1d/{}'
ADVISOR_PROMO_EVENTS_LOG_1_DAY = '//home/logfeller/logs/advisor-promoevents-log/1d/{}'

ADVISOR_POSTBACKS_PATH = 'money-reports/adnetwork-postbacks/{}'
LAUNCHER_MONEY_REPORTS_PATH = 'money-reports/adnetwork-postbacks-reports/{}'
ZEN_MONEY_REPORTS_PATH = '//home/recommender/zen-reports/money-export/{}'
PARTNER_REPORTS_PATH = 'money-reports/partner-reports/{}'

DIRECT_POSTCLICKS_LOG = '//home/logfeller/logs/metrika-postclicks-log/1d/{}'
BS_HIT_LOG = '//home/logfeller/logs/bs-hit-log/1d/{}'
YANDEX_DIRECT_CONVERSIONS_PATH = 'money-reports/yandex_direct_conversions/{}'

CLIDS_JSON_FILE = 'advisor_money_partner_clids.json'
DISCOVERY_CLID_NUMBER = 1011

DISTRIBUTION_URL = 'https://distribution.yandex.net/api/v2/statistics/basic/report/?lang=ru&oauth_token={}'
DISTRIBUTION_OAUTH_TOKEN = os.environ.get('DISTRIBUTION_OAUTH_TOKEN')

HASOFFERS_API_TOKEN = os.environ.get('HASOFFERS_API_TOKEN')
HASOFFERS_URL = 'https://yandex.api.hasoffers.com/Apiv3/json?NetworkToken={}'

METRIKA_MOBILE_LOG_1_DAY = '//home/logfeller/logs/metrika-mobile-log/1d/{}'
METRIKA_MOBILE_LOG_30_MIN = '//home/logfeller/logs/metrika-mobile-log/30min/{}'
LAUNCHER_API_KEY = '37460'
