import httpgeobase

geobase_lookuper = httpgeobase.Lookup()


def get_country_by_ip(ip):
    """
    ISO country code from IP
    :param ip:
    :return:
    """
    if not ip:
        return None
    try:
        for region in geobase_lookuper.regions(str(ip)):
            if region.type == 3:
                return region.iso_name
    except RuntimeError:
        # wrong IP format
        pass
    return None


countries = geobase_lookuper.regions_by_type(3)
countries_id_map = {country.iso_name: country.id for country in countries}
