import logging
import mongoengine as me

from advisor_money.settings import ADVISOR_MONGO_URI, ADVISOR_MONGO_DB_NAME
from pymongo import ReadPreference
from pymongo.bulk import BulkOperationBuilder

logger = logging.getLogger(__name__)

try:
    me.connect(
        db=ADVISOR_MONGO_DB_NAME,
        host=ADVISOR_MONGO_URI,
        read_preference=ReadPreference.NEAREST
    )
except:
    logger.exception('Cant connect to mongo with mongoengine')


class MongoBulk(me.Document):
    meta = {
        'abstract': True,
    }

    class BulkWrapper(object):
        __slots__ = '__bulk'

        def __init__(self, bulk):
            assert isinstance(bulk, BulkOperationBuilder), 'expected pymongo.bulk.BulkOperationBuilder type only'
            self.__bulk = bulk

        def find(self, selector):
            return self.__bulk.find(selector)

        def insert(self, document):
            return self.__bulk.insert(document)

        def execute(self, write_concern=None):
            if self.__bulk._BulkOperationBuilder__bulk.ops:
                return self.__bulk.execute(write_concern)
            logger.warning('No operations to execute')

    @classmethod
    def get_bulk(cls):
        """Mongoengine models bulk update hack - get bulk object"""
        # noinspection PyProtectedMember
        return MongoBulk.BulkWrapper(cls._get_collection().initialize_unordered_bulk_op())

    def add_to_bulk(self, bulk):
        """Mongoengine models bulk update hack - add model to bulk object"""
        self.validate()
        updates, removals = self._delta()
        update_query = {}
        if updates:
            update_query["$set"] = updates
        if removals:
            update_query["$unset"] = removals
        bulk.find({"_id": self.pk}).upsert().update(update_query)
