from datetime import datetime
import mongoengine as me

from advisor_money.models import MongoBulk


class Postback(MongoBulk):
    _id = me.StringField(required=True, primary_key=True)
    adnetwork = me.StringField(required=True)
    package_name = me.StringField(required=True)
    offer_id = me.StringField(required=True)
    impression_id = me.StringField(required=True)
    payout = me.FloatField(required=True)
    payout_unconverted = me.FloatField(required=True)
    currency = me.StringField(required=True)

    timestamp = me.DateTimeField(required=False, default=datetime.utcnow)

    click_timestamp = me.DateTimeField(required=False)
    clid = me.StringField(required=True)
    experiment = me.StringField(required=True)
    request = me.StringField(required=True)
    payout_ip = me.StringField(required=True)
    click_ip = me.StringField(required=False)
    uuid = me.UUIDField(required=True)
    device_id = me.UUIDField(required=True)
    view_type = me.StringField(required=True)
    country = me.StringField(required=True)

    ad_id = me.StringField(required=False)
    android_id = me.StringField(required=False)
    place = me.StringField(required=True)

    def validate(self, **kwargs):
        self.pk = self.get_id()
        super(Postback, self).validate(**kwargs)

    def get_id(self):
        return self.impression_id

