import mongoengine as me

from advisor_money.models import MongoBulk
from advisor_money.utils.date_utils import utc_today_datetime


class PromoOfferStats(MongoBulk):
    _id = me.StringField(required=True, primary_key=True)
    offer_id = me.StringField(required=True)
    daily_conversions = me.IntField(required=False)
    monthly_conversions = me.IntField(required=False)
    daily_payout = me.FloatField(required=False)
    monthly_payout = me.FloatField(required=False)
    date = me.DateTimeField(required=True, default=utc_today_datetime)

    meta = {
        'indexes': [
            'date',
        ],
        'index_background': True,
    }

    def validate(self, **kwargs):
        self.pk = self.get_id()
        super(PromoOfferStats, self).validate(**kwargs)

    def get_id(self):
        return '{offer_id} | {date}'.format(offer_id=self.offer_id, date=self.date.date().isoformat())

    def __hash__(self):
        return hash(self.get_id())

    def __unicode__(self):
        return self.get_id()

    def __eq__(self, other):
        if isinstance(other, PromoOfferStats):
            return self.get_id() == other.get_id()
        return False
