import logging
from decimal import Decimal

from advisor_money.partners.base import BasePartner, ActivationsPartner

logger = logging.getLogger(__name__)


class FlyRevShare(BasePartner):
    name = 'fly_rev_share'
    discovery_clid = 2296326
    shared_revenue = Decimal('0.5')


class FlyActivationsBase(ActivationsPartner):
    currency_rate_source = 'cbrf'
    activation_price_currency = 'RUB'

    def __init__(self, report_date):
        super(FlyActivationsBase, self).__init__(report_date)
        if not self.activations:
            logger.error(
                'No activations found for partner {name} since {start_date} until {end_date}'.format(
                    name=self.name,
                    start_date=self.report_date.replace(day=1).isoformat(),
                    end_date=self.report_date.isoformat()
                )
            )

    def rate_date(self, date):
        # using currency rate on date of activation
        return date

    def calculate_revenue(self, revenues, revenue_date):
        # calculating revenue only by activations
        self.calculate_revenue_by_activations(revenue_date)


# for future purposes
class FlyHigh(FlyActivationsBase):
    name = 'fly_high'
    discovery_clid = 2296327
    activation_price = Decimal('13.43')


class FlyLow(FlyActivationsBase):
    name = 'fly_low'
    discovery_clid = 2296328
    activation_price = Decimal('11.9')
