from decimal import Decimal

from advisor_money.partners.base import BasePartner


class HuaweiRed(BasePartner):

    name = 'huawei_red'
    discovery_clid = 2315329
    shared_revenue = Decimal('0.5')

    def need_processing(self, revenue):
        return revenue['source'] == 'zen'


class HuaweiLite(BasePartner):

    name = 'huawei_lite'
    discovery_clid = 2315330
    shared_revenue = Decimal('0.5')

    def need_processing(self, revenue):
        return revenue['source'] == 'zen'
