import logging
from decimal import Decimal

from advisor_money.partners.base import ActivationsPartner

logger = logging.getLogger(__name__)


class LavaBase(ActivationsPartner):

    activation_price_currency = 'INR'
    activation_regions = (
        994,  # India
    )

    def need_processing(self, revenue):
        return revenue['source'] == 'zen'


class LavaExclusive(LavaBase):
    name = 'lava_exclusive'
    discovery_clid = 2296333
    shared_revenue = Decimal('0.5')
    activation_price = Decimal(11)  # price in INR


class LavaNonExclusive(LavaBase):
    name = 'lava_non_exclusive'
    discovery_clid = 2296334
    shared_revenue = Decimal('0.5')
    activation_price = Decimal(9)  # price in INR
