from decimal import Decimal

from advisor_money.partners.base import MultiAdsPartner


# https://st.yandex-team.ru/ZEN-16844
class MeizuZenkit(MultiAdsPartner):
    name = 'meizu_zenkit'
    discovery_clid = 2313737
    shared_revenue = Decimal('0.5')
    shared_revenue_by_adnetwork = {
        'DIR': Decimal('0.8')
    }

    def need_processing(self, revenue):
        return revenue['source'] == 'zen'


class MeizuZenkit2(MultiAdsPartner):
    name = 'meizu_zenkit_2'
    discovery_clid = 2329968
    shared_revenue = Decimal('0.5')
    shared_revenue_by_adnetwork = {
        'DIR': Decimal('0.8')
    }

    def need_processing(self, revenue):
        return revenue['source'] == 'zen'
