from abc import ABCMeta
from decimal import Decimal

from advisor_money.partners.base import BasePartner


class BaseMultilaserBrowser(BasePartner):
    __metaclass__ = ABCMeta

    shared_revenue = Decimal('0.6')
    regions = (
        94,  # Brazil
    )

    def need_processing(self, revenue):
        return revenue['source'] == 'zen' and revenue['country_id'] in self.regions


class MultilaserBrowserPhone(BaseMultilaserBrowser):

    name = 'multilaser_browser_phone'
    discovery_clid = 2297208


class MultilaserBrowserTablet(BaseMultilaserBrowser):

    name = 'multilaser_browser_tablet'
    discovery_clid = 2297209
