from decimal import Decimal

from advisor_money.partners.base import MultiAdsPartner


# https://st.yandex-team.ru/ZEN-15560
class Sony(MultiAdsPartner):
    name = 'sony'
    discovery_clid = 2330903
    shared_revenue = Decimal('0.35')
    shared_revenue_by_adnetwork = {
        'DIR': Decimal('0.7')
    }

    def need_processing(self, revenue):
        return revenue['source'] == 'zen'


# https://st.yandex-team.ru/ZEN-16845
class SonyFota(MultiAdsPartner):
    name = 'sony_fota'
    discovery_clid = 2322184
    shared_revenue = Decimal('0.35')
    shared_revenue_by_adnetwork = {
        'DIR': Decimal('0.7')
    }

    def need_processing(self, revenue):
        return revenue['source'] == 'zen'
