from decimal import Decimal

from advisor_money.partners.base import BasePartner


class ZTE(BasePartner):

    name = 'zte'
    discovery_clid = 2296341
    shared_revenue = Decimal('0.5')

    def need_processing(self, revenue):
        if revenue['adnetwork'].upper() == 'DIR' or revenue['source'] != 'zen':
            return False
        return True
