def import_settings():
    import os
    from importlib import import_module
    default_settings_module = 'advisor_money.default_settings'
    environment_variable = 'MONEY_SETTINGS_MODULE'
    settings_module_name = os.environ.get(environment_variable, default_settings_module)
    module = import_module(settings_module_name)
    globals().update(
        {n: getattr(module, n) for n in module.__all__}
        if hasattr(module, '__all__') else
        {k: v for (k, v) in module.__dict__.items() if not k.startswith('_')}
    )


# noinspection PyBroadException
try:
    import_settings()
except:
    from default_settings import *
