from datetime import datetime, date, timedelta

ONE_DAY_DELTA = timedelta(days=1)


def get_yesterday():
    return date.today() - ONE_DAY_DELTA


def date_to_datetime(d):
    return datetime.combine(d, datetime.min.time())


def utc_today():
    return datetime.utcnow().date()


def utc_today_datetime():
    return date_to_datetime(utc_today())


def date_range(start_date, end_date, delta=ONE_DAY_DELTA):
    curr_date = start_date
    while curr_date <= end_date:
        yield curr_date
        curr_date += delta
