from datetime import datetime, time

import yenv
import yt.wrapper as yt
from nile.api.v1 import clusters
from nile.files import Package, DevelopPackage

from advisor_money.default_settings import YT_PROXY, YT_TOKEN, YT_POOL
from advisor_money.settings import YT_ROOT, BASE_DIR, YT_ADVISOR_TMP

LOCK_FORMAT = 'scoped_lock_yandex_mobile_advisor_money_{environment}_{name}'
TABLE_INDEX_FIELD = '__table_idx'


def get_yt_path(rel_path, root=None):
    if rel_path.startswith('//'):
        if not root:
            return rel_path
        else:
            raise ValueError("Can not build valid yt_path from path={} and root={}".format(rel_path, root))

    if root is None:
        root = YT_ROOT

    return yt.ypath_join(root, rel_path)


def make_yt_path(rel_path):
    path = get_yt_path(rel_path)
    if not yt.exists(path=path):
        yt.create_table(path=path, recursive=True)
    return path


def table_should_exist(hour):
    now_time = datetime.utcnow().time()
    return now_time > time(hour=hour)


def make_lock_name(name):
    return LOCK_FORMAT.format(name=name, environment=yenv.type)


class YtTask(object):
    pass


class YtMapper(YtTask):
    def __init__(self, source_table, destination_table):
        self.source_table = source_table
        self.destination_table = destination_table

    def run(self):
        yt.run_map(
            binary=self.mapper,
            source_table=self.source_table,
            destination_table=self.destination_table,
            format='json',
        )

    def mapper(self, row):
        raise NotImplemented


def get_cluster():
    if yenv.type == 'development':
        cluster_packages = [
            DevelopPackage(BASE_DIR),
        ]
    else:
        cluster_packages = [
            Package('advisor_money'),
        ]

    return clusters.YT(
        proxy=YT_PROXY,
        pool=YT_POOL,
        token=YT_TOKEN
    ).env(
        packages=cluster_packages,
        templates=dict(
            tmp_root=YT_ADVISOR_TMP
        )
    )
