#!/usr/bin/env python

from setuptools import setup, find_packages

from version import VERSION

setup(
    name='advisor_money',
    version=VERSION,
    author='Anton Grigoryev',
    author_email='griganton@yandex-team.ru',
    packages=find_packages(),
    entry_points={
        'console_scripts': [
            'hasoffers_conversions = advisor_money.scripts.hasoffers_conversions:cli',
            'load_clids = advisor_money.scripts.load_clids:cli',
            'monitoring = advisor_money.scripts.monitoring:cli',
            'parse_postbacks = advisor_money.scripts.parse_postbacks:cli',
            'parse_postbacks_mongo = advisor_money.scripts.parse_postbacks_mongo:cli',
            'partners_report = advisor_money.scripts.partners_report:cli',
            'postbacks_report = advisor_money.scripts.postbacks_report:cli',
            'promo_stats = advisor_money.scripts.promo_stats:cli'
        ],
    },
    options={
        'build_scripts': {
            'executable': '/usr/bin/python',
        },
    },
    test_suite='advisor_money.tests',
    test_runner='django.test.runner.DiscoverRunner'
)
