from datetime import datetime
from subprocess import Popen

import os
import re

from version import VERSION

ticket_re = re.compile(r'\[?([A-Z]+-[0-9]+)\]?')


def get_version():
    while True:
        new_version = raw_input('Input new version (current %s): ' % VERSION)
        if re.match('^\d+\.\d+\.\d+$', new_version):
            return new_version
        print 'Bad version format'


def get_changes():
    print "Input changes (line by line), leave blank to finish)"
    while True:
        change = raw_input()
        if not change:
            break
        change = ticket_re.sub(r'[\1](https://st.yandex-team.ru/\1)', change)
        yield ' - ' + change


template = "### Version {version}\n[@{login}](https://staff.yandex-team.ru/{login}) {date}\n\n{changes}\n\n"

if __name__ == '__main__':
    changelog = 'CHANGELOG.md'
    version_py = 'version.py'

    version = get_version()
    with open(changelog, 'r') as f:
        old_changelog = f.read()
    with open(changelog, 'w') as f:
        f.write(template.format(
            version=version,
            date=datetime.now().strftime('%a, %d %b %Y %H:%M:%S'),
            login=os.environ['USER'],
            changes='\n'.join(get_changes()),
        ) + old_changelog)
    print '%s has been updated' % changelog
    with open(version_py, 'w') as f:
        f.write("VERSION = '%s'\n" % version)
    print '%s has been updated' % version_py
    Popen(('git', 'commit', '-o', changelog, '-o', version_py, '-m', 'version up (%s)' % version))
    print 'changes committed'
