# -*- coding: utf-8 -*-

import unittest

from localization_tools import LocalizationUser, LazyItemsCache, UserSpecificConfig, Translator

localization_project = 'launcher'
translator_project = 'launcher_translations'


class LocalizationTest(unittest.TestCase):
    def test_items_cache(self):
        items = LazyItemsCache()
        self.assertGreater(len(list(items[localization_project].getAllItems())), 0)

    def config_test(self, user):
        config = UserSpecificConfig(user, localization_project)
        for item in config.get_all_enabled_items():
            value = config.get_value(item.name)
            self.assertEqual(item.value, value)

    def test_config(self):
        self.config_test(LocalizationUser())

    def test_not_ascii_model(self):
        self.config_test(
            LocalizationUser(device_manufacturer='Inco Air', device_model=u'INCO AIR®')
        )

    def translator(self, language, country):
        translator = Translator(
            LocalizationUser(language=language, country=country),
            translator_project
        )

        for item in translator.get_all_enabled_items()[:10]:
            # todo: tmp decision - mock tests in future
            if item.name.startswith('backend_local_subtitle_3') or item.name.startswith('backend_jafar'):
                continue

            translate = translator.translate(item.name)
            self.assertTrue(bool(translate), '%s in translations in None' % item.name)

    def test_translator_ascii(self):
        self.translator('en', 'US')

    def test_translator_utf(self):
        self.translator('ru', 'RU')


if __name__ == "__main__":
    unittest.main()
