# slack hooks can be configured via web GUI (see "Incoming WebHooks")
import logging
import os

SLACK_HOOKS = {
    # by default pushes to #backend-releases
    'jafar': 'https://hooks.slack.com/services/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',
    'launcher': 'https://hooks.slack.com/services/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',
    'updater': 'https://hooks.slack.com/services/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',
    'money': 'https://hooks.slack.com/services/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',
    'localization-admin': 'https://hooks.slack.com/services/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',
    'cobra': 'https://hooks.slack.com/services/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',
}

QLOUD_OAUTH_TOKEN = os.environ.get('QLOUD_OAUTH_TOKEN')
ROBOT_ARCANUM_TOKEN = os.environ.get('ROBOT_ARCANUM_TOKEN')

QLOUD_NOTIFICATION_STATUSES = [
    'PREPARING',
    'DEPLOYED'
]


LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'default': {
            'format': '[%(asctime)s] [%(process)d] [%(levelname)s] [%(name)s] %(message)s',
            'datefmt': '%Y-%m-%d %H:%M:%S',
            'class': 'logging.Formatter',
        },
        'stream': {
            'format': '[%(asctime)s] [%(levelname)s] %(message)s',
            'datefmt': '%H:%M:%S',
            'class': 'logging.Formatter',
        },
        'raw': {
            'format': '%(message)s',
            'datefmt': '',
        },
        'json': {
            '()': 'ylog.format.QloudJsonFormatter',
        },
    },
    'handlers': {
        'qloud': {
            'class': 'logging.StreamHandler',
            'formatter': 'json',
        }
    },
    'loggers': {
        '': {
            'level': logging.INFO,
            'handlers': ['qloud']
        }
    }
}
