#!/usr/share/python/yandex-mobile-advisor-sentry/bin/python
# -*- coding: utf-8 -*-

"""
to setup advisor sentry projects run this script after sentry upgrade
$ sentry upgrade
$ sentry_setup.py
"""

from sentry.utils.runner import configure

configure()

from sentry.models import (
    Team, Project, ProjectKey, ProjectOption, User, Organization, OrganizationMember, OrganizationMemberTeam
)

PROJECTS = (
    {'id': 2, 'name': 'launcher', 'key': '9a3c74f2b5164848838f9476417b5c68:655b1576fe194e97869f047eaea789cd'},
    {'id': 3, 'name': 'launcher-test', 'key': 'ec3e3826514e4c08b33c9286f4c4bad2:52da7e3f692f4c9984ae1785d1714c2e'},
    {'id': 4, 'name': 'jafar', 'key': '6ec7ded568664a8b8fba8c4e70bb5959:1fb97ac09f464ccd9e04f44f49c5239e'},
    {'id': 5, 'name': 'jafar-test', 'key': 'd2a152b566c74b089ed86976df1bf658:2dbe72c17b8d4eee9b5b1b127b9d9814'},
)

USERS = (
    {'name': 'rtuaev', 'fname': 'Roman Tuaev', 'role': 'owner',
     'pass': 'pbkdf2_sha256$12000$NUp0FCKLqldw$SaswbbMjMdYEHLvrLj0X7TzeNB0c2gSmbPVKmCZ7M7c='},
    {'name': 'smoroz', 'fname': 'Stepan Moroz', 'role': 'admin',
     'pass': 'pbkdf2_sha256$12000$9FqTLaXdoqSG$dDoU/31Y1OfxbEUrhbDPsdCdzU4ziJ7MnRe/eZ1FPoM='},
    {'name': 'igoshkin', 'fname': 'Alexander Igoshkin', 'role': 'member',
     'pass': 'pbkdf2_sha256$12000$Ows2c4d1af8K$PdHX+ZiLpISmWVK/pSYPIRl/wWXJ/LHgzEryU1yvPIE='},
    {'name': 'griganton', 'fname': 'Anton Grigoriev', 'role': 'member',
     'pass': 'pbkdf2_sha256$12000$7WvxpcRb5BPz$ZUrOV0fcDC4LtpS28/s0vWhY0aHv+MIpodFjcKIyWeo='},
    {'name': 'anglerfish', 'fname': 'Artem Khurshudov', 'role': 'member',
     'pass': 'pbkdf2_sha256$12000$F4ohqi66uC6I$uDemtAivDEnF64qanSltvKf2Bmz6OsClMX/Q9RkbnI4='},
)


def setup():
    organization = Organization.objects.get(name='Sentry')

    Team.objects.filter(name='advisor').delete()
    team = Team(name='advisor', organization=organization)
    team.save()

    Project.objects.filter(name__in=[project['name'] for project in PROJECTS]).delete()

    for project in PROJECTS:
        project_name = project['name']
        project_inst = Project(id=project['id'], name=project_name, organization=organization, team=team)
        project_inst.save()

        option = ProjectOption(project=project_inst, key=u'mail:subject_prefix', value=u'[advisor sentry]')
        option.save()

        key = ProjectKey.objects.get(project=project_inst)
        key.public_key, key.secret_key = project['key'].split(':')
        key.save()
        print 'adding project: %15r  DSN: %r' % (project_name, key.get_dsn())

    User.objects.all().delete()

    for user in USERS:
        name = user['name']
        role = user['role']
        print 'adding user: %s' % name
        sentry_user = User(username=name)
        sentry_user.is_superuser = bool(role == 'owner')
        sentry_user.name = user['fname']
        sentry_user.email = name + '@yandex-team.ru'
        sentry_user.password = user['pass']
        sentry_user.save()

        member = OrganizationMember.objects.create(organization=organization, user=sentry_user, role=role)
        OrganizationMemberTeam.objects.create(organizationmember=member, team=team)

        if role == 'owner':
            OrganizationMemberTeam.objects.create(organizationmember=member, team=Team.objects.get(name='Sentry'))


def show_objects():
    for obj in ProjectOption.objects.all(): print repr(obj)
    for obj in Project.objects.all(): print repr(obj)
    for obj in Team.objects.all(): print repr(obj)
    for obj in User.objects.all(): print repr(obj)
    for obj in Organization.objects.all(): print repr(obj)
    for obj in Project.objects.all(): print '%23s %s' % (obj.name, ProjectKey.objects.get(project=obj).get_dsn())


setup()
show_objects()
