#pragma once

#include <fstream>
#include <vector>
#include <string>
#include <stdexcept>


namespace shared_localization {

    class MalformedConfigError : public std::logic_error {
    public:
        explicit MalformedConfigError(const std::string &what);
    };

    struct Config {
        Config();

        explicit Config(const std::string &path);

        void loadFromFile(const std::string &path);

        void validate() const;

        std::string getCollectionName(const std::string &collection_subname) const;

        std::string getPidfilePath() const;

        std::string getLockfilePath() const;

        // Mongo options
        std::string mongo_uri;
        std::string db_name;
        unsigned int mongo_retry_timeout;

        // SHM Options
        std::string memory_segment_name;
        unsigned long long memory_limit;
        unsigned int bucket_number;

        // Logging options
        std::string logfile_path;
        std::string log_format;
        unsigned int log_level;

        // Sync options
        static const std::string run_directory;
        static const std::string tmp_directory;
        std::string pidfile_name;
        std::uint64_t manager_check_count;

        // Content options
        unsigned int update_interval;
        std::string project_name;
        std::string applications_collection_subname;
    };

} // end of shared_localization namespace
