#include "local_items.hpp"

namespace shared_localization {

    ItemLocalization::EnableConditions::EnableConditions(UniversalAllocator &allocator) :
            device_types(allocator),
            uuids(allocator),
            region_ids_init(allocator),
            region_ids_init_blacklist(allocator),
            region_ids(allocator),
            region_ids_blacklist(allocator),
            language(allocator),
            country(allocator),
            applications(allocator),
            clids(std::less<unsigned int>(), allocator),
            models(allocator),
            extended_params(std::less<ShmString>(), allocator) {}

    ItemLocalization::ItemLocalization(UniversalAllocator &allocator)
            : conditions(allocator) {}

    SharedLocalItems::SharedLocalItems(const boost::interprocess::managed_shared_memory &segment)
            : allocator(UniversalAllocator(segment.get_segment_manager())), items(allocator) {}

    ItemLocalization::EnableConditions::Application::Application(UniversalAllocator &allocator)
            : aliases(std::less<ShmString>(), allocator), version(allocator) {}


    ItemLocalization::EnableConditions::Model::Model(UniversalAllocator &allocator)
            : vendor(allocator), name(allocator) {}

    ItemLocalization::EnableConditions::VersionRange::VersionRange(UniversalAllocator &allocator)
            : from(allocator), to(allocator) {}


    LocalizationFormatError::LocalizationFormatError(const std::string &what)
            : std::runtime_error(what) {}

    LocalItemsContainer::LocalItemsContainer(boost::interprocess::managed_shared_memory &segment,
                                             unsigned int bucket_count, std::uint64_t version)
            : cache(bucket_count, boost::hash<ShmString>(), std::equal_to<ShmString>(),
                    segment.get_allocator<LocalItemsAllocator>()),
              clients(std::less<int>(), segment.get_allocator<IntAllocator>()), manager_version(version),
              manager_pid(getpid()) {}

}  // end of shared_localization namespace
