#pragma once

#include <functional>

#include <boost/date_time/posix_time/posix_time.hpp>
#include <boost/interprocess/allocators/allocator.hpp>
#include <boost/interprocess/containers/vector.hpp>
#include <boost/interprocess/containers/map.hpp>
#include <boost/interprocess/containers/set.hpp>
#include <boost/interprocess/containers/string.hpp>
#include <boost/interprocess/managed_shared_memory.hpp>
#include <boost/interprocess/sync/interprocess_sharable_mutex.hpp>
#include <boost/functional/hash.hpp>
#include <boost/unordered_map.hpp>
#include <boost/optional.hpp>


namespace shared_localization
{

using UniversalAllocator = boost::interprocess::allocator
    < void
    , boost::interprocess::managed_shared_memory::segment_manager >;

using CharAllocator = boost::interprocess::allocator
    < char
    , boost::interprocess::managed_shared_memory::segment_manager >;

using IntAllocator = boost::interprocess::allocator
    < int
    , boost::interprocess::managed_shared_memory::segment_manager >;

using UIntAllocator = boost::interprocess::allocator
    < unsigned int
    , boost::interprocess::managed_shared_memory::segment_manager >;

using ShmString = boost::interprocess::basic_string<char, std::char_traits<char>, CharAllocator>;

using StringAllocator = boost::interprocess::allocator
    < ShmString
    , boost::interprocess::managed_shared_memory::segment_manager >;

using ShmStringVector = boost::interprocess::vector<ShmString, StringAllocator>;

using ShmIntSet = boost::interprocess::set<int, std::less<int>, IntAllocator>;

using ShmUIntSet = boost::interprocess::set< unsigned int, std::less<unsigned int>, UIntAllocator>;

using ShmStringSet = boost::interprocess::set<ShmString, std::less<ShmString>, StringAllocator>;


struct ItemLocalization
{
    ItemLocalization(UniversalAllocator& allocator);
    boost::optional<ShmString> value;
    struct EnableConditions
    {
        EnableConditions(UniversalAllocator& allocator);

        struct Model
        {
            Model(UniversalAllocator& allocator);
            ShmString vendor;
            ShmString name;
        };
        using ModelAllocator = boost::interprocess::allocator
            < Model
            , boost::interprocess::managed_shared_memory::segment_manager >;
        using Models = boost::interprocess::vector<Model, ModelAllocator>;

        using ClidAllocator = boost::interprocess::allocator
            < std::pair<const unsigned int, ShmUIntSet >
            , boost::interprocess::managed_shared_memory::segment_manager >;
        using Clids = boost::interprocess::map
            < unsigned int
            , ShmUIntSet
            , std::less<unsigned int>
            , ClidAllocator>;

        using ExtendedParamAllocator = boost::interprocess::allocator
            < std::pair<const ShmString, ShmString>
            , boost::interprocess::managed_shared_memory::segment_manager >;
        using ExtendedParams = boost::interprocess::map
            < ShmString
            , ShmString
            , std::less<ShmString>
            , ExtendedParamAllocator >;

        struct VersionRange
        {
            VersionRange(UniversalAllocator& allocator);
            ShmString from;
            ShmString to;
        };
        struct Application
        {
              Application(UniversalAllocator& allocator);
              ShmStringSet aliases;
              VersionRange version;
        };
        using ApplicationAllocator = boost::interprocess::allocator
            < Application
            , boost::interprocess::managed_shared_memory::segment_manager >;
        using Applications = boost::interprocess::vector<Application, ApplicationAllocator>;

        bool enabled;
        ShmStringVector device_types;
        ShmStringVector uuids;
        ShmUIntSet region_ids_init;
        ShmUIntSet region_ids_init_blacklist;
        ShmUIntSet region_ids;
        ShmUIntSet region_ids_blacklist;
        ShmString language;
        ShmString country;
        Applications applications;
        boost::posix_time::ptime time_start = boost::posix_time::neg_infin;
        boost::posix_time::ptime time_end = boost::posix_time::pos_infin;
        double audience_ratio;
        double audience_offset;
        Clids clids;
        Models models;
        ExtendedParams extended_params;

    } conditions;
};


using ItemLocalizationAllocator = boost::interprocess::allocator
    < ItemLocalization
    , boost::interprocess::managed_shared_memory::segment_manager >;

using ItemLocalizations = boost::interprocess::vector<ItemLocalization, ItemLocalizationAllocator>;

struct ItemOptions
{
    boost::optional<ShmString> audience_salt;
};

using LocalItemsAllocator = boost::interprocess::allocator
    < std::pair<ShmString, std::pair<ItemOptions, ItemLocalizations> >
    , boost::interprocess::managed_shared_memory::segment_manager >;

using LocalItems = boost::unordered_map
    < ShmString
    , std::pair<ItemOptions, ItemLocalizations>
    , boost::hash<ShmString>
    , std::equal_to<ShmString>
    , LocalItemsAllocator>;

struct SharedLocalItems
{
    SharedLocalItems(const boost::interprocess::managed_shared_memory& segment);

    UniversalAllocator allocator;
    LocalItems items;

};

struct LocalItemsContainer
{
    LocalItemsContainer(boost::interprocess::managed_shared_memory&, unsigned int bucket_number, std::uint64_t version);
    LocalItems cache;
    boost::interprocess::interprocess_sharable_mutex cache_mutex;

    ShmIntSet clients;
    boost::interprocess::interprocess_sharable_mutex clients_mutex;

    bool is_ready = false;
    std::uint64_t manager_version;
    pid_t manager_pid;
};

class LocalizationFormatError: public std::runtime_error
{
public:
    explicit LocalizationFormatError(const std::string& what);
};

}  // end of shared_localization namespace
