#pragma once

#include "config.hpp"
#include "local_items.hpp"

#include <string>
#include <map>
#include <set>

#include <mongocxx/database.hpp>
#include <bsoncxx/document/view.hpp>


namespace shared_localization {

    class Config;

    using ApplicationsCache = std::map<std::string, std::set<std::string>>;

    class LocalItemsDb {
    public:
        LocalItemsDb(const Config &cfg);

        void dump(const std::string &project_name, SharedLocalItems &items_cache);

    private:
        const Config &cfg_;

        void doDump(
                mongocxx::database db,
                const std::string &project_name,
                SharedLocalItems &items_cache);
    };

    void processItem(const bsoncxx::document::view &view, SharedLocalItems &shared_items,
                     const ApplicationsCache &apps_cache);

    void processYandexApp(const bsoncxx::document::view &doc, ApplicationsCache &cache);
}  // end of shared_localization namespace
