#include "user_info.hpp"
#include "items_cache.hpp"

#include <boost/python.hpp>

#include "converters.hpp"

namespace py = boost::python;
namespace sl = shared_localization;

BOOST_PYTHON_MODULE(_shared_localization)
{
    using namespace boost::python;


    PyDateTime_IMPORT;
    to_python_converter<std::vector<std::string>, type_into_python<std::vector<std::string>>> ();
    to_python_converter<boost::posix_time::ptime, type_into_python<boost::posix_time::ptime> >();

    boost_function_from_python_function();

    class_<sl::ItemsCacheProxy>("ItemsCache", py::no_init)
        .def("getAllItems", &sl::ItemsCacheProxy::getAllItems)
        .def("getItemValue", &sl::ItemsCacheProxy::getItemValue)
        .def("getAllEnabledItems", &sl::ItemsCacheProxy::getAllEnabledItems)
        .def("isItemEnabled", &sl::ItemsCacheProxy::isItemEnabled)
        .def("getExpirationDate", &sl::ItemsCacheProxy::getExpirationDate)
        .def("isReady", &sl::ItemsCacheProxy::isReady)
    ;

    def("getCache", &sl::ItemsCache::getCache);
    def("isReady", &sl::ItemsCache::allAreReady);
    def("setExecutablePath", &sl::ItemsCache::setExecutablePath);

    class_<sl::UserInfo>("UserInfo")
        .def("setLocale",
            static_cast<sl::UserInfo& (sl::UserInfo::*)(const std::string&)>(&sl::UserInfo::setLocale),
            return_self<>(),
            args("locale"))
        .def("setLocale",
            static_cast<sl::UserInfo& (sl::UserInfo::*)(const std::string&, const std::string&)>(&sl::UserInfo::setLocale),
            return_self<>(),
            args("language", "country"))
        .def("setRegionIdsInit", &sl::UserInfo::setRegionIdsInit, return_self<>())
        .def("setRegionIds", &sl::UserInfo::setRegionIds, return_self<>())
        .def("setClid", &sl::UserInfo::setClid, return_self<>())
        .def("setUuid", &sl::UserInfo::setUuid, return_self<>())
        .def("setDeviceType", &sl::UserInfo::setDeviceType, return_self<>())
        .def("setModel", &sl::UserInfo::setModel, return_self<>())
        .def("setApplication", &sl::UserInfo::setApplication, return_self<>())
        .def("setScreenSize", &sl::UserInfo::setScreenSize, return_self<>())
        .def("setScreenDpi", &sl::UserInfo::setScreenDpi, return_self<>())
        .def("setExtendedParam", &sl::UserInfo::setExtendedParam, return_self<>())
        .def("__str__", &sl::UserInfo::toString)
    ;
}
