import os

bind = '[::]:80'
worker_class = 'gevent'
workers = os.environ.get('QLOUD_NUM_WORKERS', 1)
timeout = 60

# Docker will wait only 10 seconds before hard shutdown
graceful_timeout = 5

pidfile = '/var/run/gunicorn.pid'

access_log_format = '%(t)s %({Host}i)s %({x-forwarded-for-y}i)s "%(r)s" %(s)s "%(f)s" "%(a)s" "%(l)s" %(L)s %(l)s ' \
                    '%(b)s "%(L)s" 0 %(unixtime_msec)s "%({x-yareqfinish}o)s" "%({x-yauuid}i)s" ' \
                    '"%({x-yarequestid}o)s" "%({x-yamisc}o)s" "-;-;-;-"'
logconfig = '/etc/gunicorn/logging.conf'

limit_request_line = 8190
