import logging

from rest_framework import exceptions, views

logger = logging.getLogger(__name__)


class MapsSearchBackendUnavailable(exceptions.APIException):
    default_detail = "Search backend is unavailable"


class CallerIDBackendUnavailable(exceptions.APIException):
    default_detail = "Caller ID backend is unavailable"


class MapsSearchRequestException(exceptions.APIException):
    default_detail = "Error processing maps search request"


# noinspection PyProtectedMember
def custom_exception_handler(exc, context):
    if isinstance(exc, (exceptions.ParseError, exceptions.ValidationError)):
        action = 'parse' if isinstance(exc, exceptions.ParseError) else 'validation'
        logger.error('%s error: %s', action, exc.detail, exc_info=True,
                     extra={'request': context['view'].request._request})
    return views.exception_handler(exc, context)
