from boto.s3.connection import S3Connection
from boto.exception import BotoClientError
from django.conf import settings
from django.utils.functional import SimpleLazyObject

mds_s3_client = SimpleLazyObject(lambda: S3Connection(
    host=settings.S3_MDS_WRITE_HOST,
    aws_access_key_id=settings.S3_MDS_ACCESS_KEY_ID,
    aws_secret_access_key=settings.S3_MDS_ACCESS_SECRET_KEY,
    validate_certs=True,
))


MDSError = BotoClientError
