from yaphone.dialer.dialer.serializers import Phone
from django.test import TestCase


class DialerTestCase(TestCase):
    def test_phone_number(self):
        def check_phone_number(formatted, result):
            self.assertEqual(Phone.get_number({'formatted': formatted}), result)

        check_phone_number('+79990123456', '+79990123456')
        check_phone_number('89990123456', '+79990123456')
        check_phone_number('25-82-04', '258204')
        check_phone_number('8 (800) 555-35-35', '+78005553535')
        check_phone_number('+1004567890123127', '+1004567890123127')
        check_phone_number('01', '01')
