import logging

from django.conf import settings
from tvm2.qloud_tvm2 import TVM2Qloud

logger = logging.getLogger(__name__)


class TvmTicketCheckError(Exception):
    pass


def get_service_ticket_headers(tvm, client_id):
    client_id = str(client_id)
    tickets = tvm.get_service_tickets(client_id)
    if not tickets:
        raise TvmTicketCheckError("Couldn't get TVM Service ticket")
    return {'X-Ya-Service-Ticket': tickets[client_id]}


def get_tvm_client():
    allowed_clients = [
        settings.MAPS_SEARCH_CLIENT_ID,
    ]

    # TVM2 object is a singleton
    return TVM2Qloud(
        client_id=settings.TVM_CLIENT_ID,
        blackbox_client=settings.BLACKBOX_CLIENT,
        api_url=settings.TVM_API_URL,
        allowed_clients=allowed_clients
    )
