from six.moves.urllib import parse
import yenv
import ylog

from django.conf import settings
from raven.contrib.django.raven_compat.models import client as raven_client

from yaphone.utils.django import get_http_header
from yaphone.utils.django.exceptions import BadRequestAPIError
from .models import UserAgent


def rewrite_url(url, host, scheme='https', path_prefix=''):
    parsed = parse.urlparse(url)
    # noinspection PyProtectedMember
    replaced = parsed._replace(scheme=scheme, netloc=host, path=path_prefix + parsed.path)
    return replaced.geturl()


def make_s3_mds_url(query, host=None):
    """
    Production S3 MDS is accessible from internet, but testing is not.
    So, we do reverse proxy for testing S3 MDS through our backend.
    """
    url = settings.S3_MDS_URL_TEMPLATE % query
    if yenv.type == 'testing' and host is not None:
        url = rewrite_url(url, host, path_prefix='get-lnchr-s3')
    return url


def get_user_agent(request):
    user_agent_string = get_http_header(request, 'USER_AGENT')
    if user_agent_string is None:
        raise BadRequestAPIError("User-Agent header is missing")
    user_agent = UserAgent.from_string(user_agent_string)
    if not user_agent:
        raise BadRequestAPIError("User-Agent header has wrong format")
    return user_agent


def add_log_context(**kwargs):
    raven_client.tags_context(kwargs)
    for key, value in kwargs.items():
        ylog.context.put_to_context(key, value)
