import logging
import os

import yenv
from tvmauth import BlackboxTvmId as BlackboxClientId

from .version import VERSION

USE_I18N = False
USE_L10N = False

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = yenv.choose_key_by_type({
    'production': False,
    'development': True,
}, fallback=True)

ALLOWED_HOSTS = ['*']

INSTALLED_APPS = [
    'django.contrib.contenttypes',
    'django.contrib.auth',
    'rest_framework',
    'yaphone.dialer.dialer',
]

# Uncaught exceptions reporting
if not DEBUG:
    INSTALLED_APPS.append('raven.contrib.django.raven_compat')

BASE_DIR = os.path.dirname(__file__)

os.environ.setdefault("REQUESTS_CA_BUNDLE", '/etc/ssl/certs')

ROOT_URLCONF = 'yaphone.dialer.dialer.urls'

SECRET_KEY = 'xtrpet&a-hvm9=vnj-f*sl+hl-1&a=h2e8^g577=4$p*e=flxj'

REST_FRAMEWORK = {
    'DEFAULT_RENDERER_CLASSES': (
        'rest_framework.renderers.JSONRenderer',
    ),
    'DEFAULT_PARSER_CLASSES': (
        'rest_framework.parsers.JSONParser',
    ),
    'EXCEPTION_HANDLER': 'yaphone.dialer.dialer.exceptions.custom_exception_handler'
}

CACHES = {
    'default': {
        'BACKEND': 'django_redis.cache.RedisCache',
        'LOCATION': 'redis://localhost:6379/1',
        'TIMEOUT': 86400,  # 1 day
        'VERSION': VERSION,
    }
}
SENTRY_URL_TEST = 'https://6c46d2747eba4682912a614557344309' \
                  '@sentry-test-proxy.t.yandex.net/506?verify_ssl=0&timeout=5'
SENTRY_URL_PROD = 'https://6d518a18b22a4da99c00c0f5e74642f1' \
                  '@sentry.iddqd.yandex.net/843?verify_ssl=0&timeout=5'

os.environ.setdefault('SENTRY_DSN', yenv.choose_key_by_type({
    'testing': SENTRY_URL_TEST,
    'production': SENTRY_URL_PROD,
    'stress': '',
    'development': '',
}, fallback=True))
SENTRY_DSN = os.getenv('SENTRY_DSN')

RAVEN_CONFIG = {
    'dsn': SENTRY_DSN,
    'string_max_length': 8192,
    'list_max_length': 256,
    'release': VERSION,
    'environment': yenv.type,
}

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'default': {
            'format': '[%(asctime)s] [%(process)d] [%(levelname)s] [%(name)s] %(message)s',
            'datefmt': '%Y-%m-%d %H:%M:%S',
            'class': 'logging.Formatter',
        },
        'json': {
            '()': 'ylog.format.QloudJsonFormatter'
        }
    },
    'handlers': {
        'qloud': {
            'class': 'logging.StreamHandler',
            'formatter': 'json'
        },
        'console': {
            'class': 'logging.StreamHandler',
            'formatter': 'default',
        },
        'sentry': {
            'level': logging.ERROR,
            'class': 'raven.contrib.django.raven_compat.handlers.SentryHandler',
        },
    },
    'loggers': {
        '': {
            'level': yenv.choose_key_by_type({
                'production': logging.INFO,
                'testing': logging.DEBUG,
            }, fallback=True),
            'handlers': yenv.choose_key_by_type({
                'production': ['qloud', 'sentry'],
                'stress': ['qloud'],
                'development': ['console'],
            }, fallback=True),
            'propagate': True,
        },
    },
}

MAPS_SEARCH_API_URL = yenv.choose_key_by_type({
    # experimental_source=default:stable is used to get production db in testing environment
    'testing': 'http://search.tst.maps.yandex.net/1.x/?experimental_source=default:stable&origin=yandex-phone',
    'stress': 'http://search.int01f.load.maps.yandex.net/1.x/?origin=yandex-phone',
    'production': 'http://search.maps.yandex.net/1.x/?origin=yandex-phone',
}, fallback=True)

MAPS_SEARCH_PROTO_API_URL = yenv.choose_key_by_type({
    'testing': 'http://addrs-testing.search.yandex.net/upper/stable/yandsearch?origin=yandex-phone',
    'stress': 'http://sas1-1691.search.yandex.net:8031/yandsearch?origin=yandex-phone',
    'production': 'http://addrs.yandex.ru:17140/yandsearch?origin=yandex-phone',
}, fallback=True)

CALLER_ID_INFO_URL = yenv.choose_key_by_type({
    'testing': 'https://cid.common.yandex.net/v7/info',
    'production': 'https://cid.yandex.net/v7/info',
}, fallback=True)

# http Geobase
GEOBASE_URL = 'http://geobase.qloud.yandex.ru'

# classic Geobase
GEODATA_BIN_PATH = '/var/cache/geobase/geodata6.bin'

# LBS
LBS_URL = 'https://api-int.lbs.yandex.net/geolocation'
LBS_TOKEN = os.environ.get('LBS_TOKEN')

os.environ.setdefault("REQUESTS_CA_BUNDLE", '/etc/ssl/certs/ca-certificates.crt')

USE_HTTP_GEOBASE = bool(os.environ.get('USE_HTTP_GEOBASE'))

S3_MDS_WRITE_HOST = yenv.choose_key_by_type({
    'production': 's3.mds.yandex.net',
    'testing': 's3.mdst.yandex.net',
}, fallback=True)
S3_MDS_ACCESS_KEY_ID = os.environ.get('S3_MDS_ACCESS_KEY_ID')
S3_MDS_ACCESS_SECRET_KEY = os.environ.get('S3_MDS_ACCESS_SECRET_KEY')
S3_MDS_BUCKET_NAME = 'lnchr-files'
S3_MDS_URL_TEMPLATE = yenv.choose_key_by_type({
    'production': 'https://lnchr-files.s3.yandex.net/%s',
    'testing': 'https://lnchr-files.s3.mdst.yandex.net/%s',
}, fallback=True)


# TVM2
def get_tvm_auth_token():
    path = '/var/lib/tvmtool/local.auth'
    if os.path.exists(path):
        with open(path) as f:
            return f.read().strip()
    return ''


if yenv.type == 'development':
    os.environ.setdefault("QLOUD_TVM_TOKEN", get_tvm_auth_token())
else:
    os.environ.setdefault("QLOUD_TVM_TOKEN", '')

BLACKBOX_CLIENT = yenv.choose_key_by_type({
    'production': BlackboxClientId.Prod,
    'testing': BlackboxClientId.Test,
}, fallback=True)

TVM_CLIENT_ID = yenv.choose_key_by_type({
    'production': '2001582',
    'testing': '2001670',
    'development': '2001672',
}, fallback=True)
TVM_CLIENT_SECRET = os.environ['QLOUD_TVM_TOKEN']

TVM_API_URL = yenv.choose_key_by_type({
    'production': None,
    'development': 'http://localhost:18080/tvm',
}, fallback=True)

MAPS_SEARCH_CLIENT_ID = yenv.choose_key_by_type({
    'production': 2001886,
    'testing': 2008261,
}, fallback=True)
