package config

import (
	"os"

	"a.yandex-team.ru/yaphone/gotifier/pkg/yenv"
)

var ArcanumToken string
var StToken string
var QToken string
var Port int

var QloudNotificationStatuses = map[string]bool{"PREPARING": true, "DEPLOYED": true}

var QloudEnvironmentURLTemplate = "https://platform.yandex-team.ru/projects/%s"
var ArcURLTemplate = "https://a.yandex-team.ru/arc/commit/%s"
var ArcCommitURLTemplate = "http://a.yandex-team.ru/api/tree/commit/%s"
var StURLTemplate = "https://st.yandex-team.ru/%s"
var StAPITransitionsURLTemplate = "https://st-api.yandex-team.ru/v2/issues/%s/transitions"
var QURL = "https://bp.mssngr.yandex.net/bot/sendMessage/"
var QChatID = "1/0/14a67f4a-438d-419f-a0eb-3039c876b57d"

func init() {
	var ok bool
	ArcanumToken, ok = os.LookupEnv("ROBOT_ARCANUM_TOKEN")
	if !ok {
		panic("ROBOT_ARCANUM_TOKEN environment variable is empty")
	}
	StToken, ok = os.LookupEnv("ROBOT_ST_TOKEN")
	if !ok {
		panic("ROBOT_ST_TOKEN environment variable is empty")
	}
	QToken, ok = os.LookupEnv("ROBOT_Q_TOKEN")
	if !ok {
		panic("ROBOT_Q_TOKEN environment variable is empty")
	}
	Port = yenv.ChooseKeyByType(map[string]interface{}{"development": 9000, "production": 80}, true).(int)
}
