﻿from collections import OrderedDict
from hashlib import md5
from urllib import quote_plus


class Resizer(object):
    def __init__(self, app=None):
        self.app = app
        if app is not None:
            self.init_app(app)

    def init_app(self, app):
        self.key = app.config['RESIZER_SECRET_KEY']
        self.host = app.config['RESIZER_HOST']

        @app.context_processor
        def register_resizer():
            return {'scale_image': self.make_scaled_image_url}

    def make_scaled_image_url(self, url, width=0, height=0, quality=90):
        url_args = OrderedDict((
            ('url', url.encode('utf-8')),
            ('width', str(width)),
            ('height', str(height)),
            # ('enlarge', 'yes'),
        ))
        data = ''.join(url_args.values()) + self.key
        url_args['key'] = md5(data).hexdigest()
        url_args['url'] = quote_plus(url_args['url'])
        url_args['quality'] = quality
        url = '%s?%s' % (self.host, '&'.join("%s=%s" % arg for arg in url_args.items()))
        return url
