
def patch_formlist():
    """
    This is a patch until PR https://github.com/wtforms/wtforms/pull/498 is merged or until another solution
    Fixes a bug with InlineFieldList where it always deletes the last entry in a list when trying to delete an entry
    :return:
    """
    from wtforms.fields.core import FieldList
    from wtforms.utils import unset_value

    def process(self, formdata, data=unset_value):
        self.entries = []
        if data is unset_value or not data:
            try:
                data = self.default()
            except TypeError:
                data = self.default

        self.object_data = data

        if formdata:
            indices = sorted(set(self._extract_indices(self.name, formdata)))
            if self.max_entries:
                indices = indices[:self.max_entries]

            ldata = list(data)
            for index in indices:
                if index < len(ldata):
                    obj_data = ldata[index]
                else:
                    obj_data = unset_value
                self._add_entry(formdata, obj_data, index=index)
        else:
            for obj_data in data:
                self._add_entry(formdata, obj_data)

        while len(self.entries) < self.min_entries:
            self._add_entry(formdata)

    FieldList.process = process


patch_formlist()
