import requests
import logging
import hashlib

UPLOAD_URL = 'https://admin.m.soft.yandex-team.ru/upload'

logger = logging.getLogger(__name__)


class AppNotFound(Exception):
    pass


def check_url(url):
    if not requests.head(url).ok:
        raise AppNotFound('url=%s not found in beta storage' % url)


class SetupWizardBetaStorage(object):
    APP = 'yphone_setup_wizard'
    DOWNLOAD_URL_TEMPLATE = 'https://m.soft.yandex.ru/download/{app}/{branch}/ysw-android.apk'

    @staticmethod
    def get_branch(package_name):
        return hashlib.md5(package_name).hexdigest()

    @classmethod
    def upload(cls, package_name, fp):
        def params():
            return {
                'app': cls.APP,
                'platform': 'androidphone',
                'branch': cls.get_branch(package_name)
            }

        files = {'file.apk': fp}
        r = requests.post(UPLOAD_URL, params=params(), files=files, verify=False)
        if r.status_code != 200:
            logger.info('apk upload failed, reason: %s', r.content)

        return r.status_code

    @classmethod
    def get_download_url(cls, package_name):
        return cls.DOWNLOAD_URL_TEMPLATE.format(app=cls.APP, branch=cls.get_branch(package_name))
