import hashlib
import yenv
from flask import current_app as app
from mdswrapper import MdsClient
from mdswrapper.exceptions import NotFound

from jafar.admin.models.base import LauncherFiles


class LauncherMdsClient(object):
    namespace = 'lnchr'
    _client = None

    @classmethod
    def create_client(cls):
        return MdsClient(
            cls.namespace, app.config['MDS_ACCESS_TOKEN'], env=yenv.choose_type(MdsClient.INTERFACES, fallback=True)
        )

    @property
    def client(self):
        if self._client is None:
            self._client = self.create_client()
        return self._client

    def save(self, filename, data, kind):
        doc = LauncherFiles.objects(filename=filename).first()
        md5 = hashlib.md5(data).hexdigest()

        if doc and hasattr(doc, 'mds_key'):
            key = doc.mds_key
            if doc.md5 == md5:
                return key

            self.client.delete(key)

        response = self.client.write(filename, data)
        LauncherFiles(md5=md5, kind=kind, filename=filename, mds_key=response.key).save()
        return response.key

    def delete(self, mds_key):
        LauncherFiles.objects(mds_key=mds_key).delete()
        try:
            self.client.delete(mds_key)
        except NotFound:
            pass

    def read_url(self, key):
        # noinspection PyProtectedMember
        return '{host}/get-{ns}/{key}'.format(
            host=self.client._interface['public'], ns=self.client._namespace, key=key
        )
