from mongoengine import (
    Document, EmbeddedDocument,
    StringField, ListField,
    BooleanField, IntField,
    EmbeddedDocumentField, DictField,
)

from jafar.admin.models.base import S3Image

class Button(EmbeddedDocument):
    STYLES = ('primary', 'transparent')

    id = StringField(required=True)
    caption = StringField(required=True)
    action = StringField(required=False)
    style = StringField(required=True, choices=STYLES)

    def __unicode__(self):
        return self.action

    meta = {
        'strict': False,
    }


class SettingsPromoBlock(Document):
    id = StringField(required=True, primary_key=True)
    experiment = ListField(StringField(required=True))
    badge = BooleanField(required=False, default=False)
    title = StringField(required=True)
    priority = IntField(required=True)
    description = StringField(required=True)
    buttons = ListField(EmbeddedDocumentField(Button))
    image = EmbeddedDocumentField(S3Image, required=False)
    show_conditions = DictField(required=False)

    meta = {
        'db_alias': 'advisor',
        'ordering': ['-priority'],
        'strict': False,
    }

    def clean(self):
        # Delete empty image
        if self.image.key is None:
            del self.image
