import logging
from datetime import datetime

from mongoengine import (
    Document, StringField,
    EmbeddedDocumentField,
    DateTimeField, ListField,
    URLField,
)

from jafar.admin.models.base import S3Image

logger = logging.getLogger(__name__)
TEXT_LENGTH = 120
VERSION_LENGTH = 30


class Theme(Document):
    DEVICE_TYPE = ('phone', 'tablet')

    title = StringField(max_length=TEXT_LENGTH, required=True)
    theme_id = StringField(max_length=TEXT_LENGTH, required=True)
    device_type = ListField(StringField(choices=DEVICE_TYPE))
    screens = ListField(EmbeddedDocumentField(S3Image))
    updated_at = DateTimeField(default=datetime.utcnow)

    meta = {
        'strict': False,
        'allow_inheritance': True,
        'db_alias': 'advisor'
    }


class SimpleTheme(Theme):
    pass


class ApkTheme(Theme):
    min_version = StringField(max_length=VERSION_LENGTH)
    tracking_url = URLField()
    preview_image = EmbeddedDocumentField(S3Image)
    preview_text_color = StringField()
    preview_background_color = StringField()
