from datetime import datetime

from mongoengine import Document, StringField, ListField, DateTimeField


class Translations(Document):
    STATUSES = (
        # https://doc.yandex-team.ru/Tanker/tech-dscr/concepts/tr-statuses.html
        'requires_translation',
        'translated',
        'approved',
        'generated',
        'expired',
        'external_translation',
    )

    title = StringField(min_length=1, max_length=100, required=True)
    project = StringField(min_length=1, max_length=100, required=True, default='launcher')
    keyset_id = StringField(min_length=1, max_length=100, required=True)
    statuses = ListField(StringField(choices=STATUSES, min_length=1), default=['approved'])
    description = StringField(required=False)
    updated_at = DateTimeField(required=False)
    created_at = DateTimeField(required=False, default=datetime.utcnow)

    meta = {
        'strict': False,
        'indexes': [('project', 'keyset_id')],
    }

    def __unicode__(self):
        return self.title
