from jafar import admin_app, mongo_configs
from jafar.admin import views
from jafar.admin.models.base import YandexCategory, History, AdminUser
from jafar.admin.models.icons import Icons
from jafar.admin.models.promo import SettingsPromoBlock
from jafar.admin.models.themes import SimpleTheme, ApkTheme
from jafar.admin.models.translations import Translations
from jafar.admin.models.wallpapers import WallpaperCategories, WallpaperColors, WallpaperBadges, MusicWallpapers
from jafar.models.yandexphone import (YandexDistributedApp, Gifts,
                                      BonusCardResources, Phone, GiftSet, PlusPromocode, GreetingMail)
from jafar.utils import get_all_subclasses


def add_model_view(model, name, category):
    admin_app.add_view(views.ModelView(model, name, category))


admin_app.add_view(views.ExperimentModelView(mongo_configs.FeedExperimentConfig, 'Experiments', 'Experiments'))
admin_app.add_view(views.StrategyModelView(mongo_configs.StrategyConfig, 'Strategies', 'Experiments'))
admin_app.add_view(views.ArrangerExperimentConfigModelView(mongo_configs.ArrangerExperimentConfig,
                                                           'Arranger', 'Experiments'))
add_model_view(mongo_configs.PriorityGroup, 'Arranger Priority Groups', 'Experiments')

# Feed recommenders
for cls in get_all_subclasses(mongo_configs.FeedRecommenderConfig):
    admin_app.add_view(views.RecommenderModelView(cls, cls.__name__, 'Feed recommenders'))

# Card configs
add_model_view(mongo_configs.CardMongoConfig, 'All configs', 'Card Configs')
for cls in get_all_subclasses(mongo_configs.CardMongoConfig):
    add_model_view(cls, cls.__name__, 'Card Configs')

# YPhone
admin_app.add_view(views.PhoneView(Phone, 'Yandex Phone', 'YPhone'))
admin_app.add_view(views.BonusCardView(BonusCardResources, 'Bonus cards', 'YPhone'))
admin_app.add_view(views.GiftsView(Gifts, 'Gift Previews', 'YPhone'))
admin_app.add_view(views.GiftSetView(GiftSet, 'Gift Set', 'YPhone'))
admin_app.add_view(views.YandexDistributedAppView(YandexDistributedApp, 'Setup wizard apps', 'YPhone'))
admin_app.add_view(views.PhoneIdCheckView(name='Phone ID check', endpoint='phone_id', category='YPhone'))
admin_app.add_view(views.PhoneUploadView(name='Phone upload', endpoint='phone_upload', category='YPhone'))
admin_app.add_view(views.PlusPromocodeView(PlusPromocode, 'Plus Promocode', 'YPhone'))
admin_app.add_view(views.GreetingMailView(GreetingMail, 'GreetingMail', 'YPhone'))
admin_app.add_view(views.SupportView(name='Support', endpoint='support', category='YPhone'))

# Vanga
admin_app.add_view(views.ModelView(mongo_configs.VangaExperimentConfig, 'Experiments', 'Vanga'))
admin_app.add_view(views.ClassifierView(mongo_configs.ClassifierModel, 'Client Models', 'Vanga'))
admin_app.add_view(views.VangaModelView(mongo_configs.VangaModel, 'Models', 'Vanga'))
admin_app.add_view(views.VangaDemoView(name='Demo', category='Vanga'))

# Other stuff
add_model_view(mongo_configs.Distributor, 'Distributors', 'Other')
add_model_view(YandexCategory, 'Categories', 'Other')
admin_app.add_view(views.GlobalConfigView(mongo_configs.GlobalJafarConfig, 'Global config', 'Other'))
admin_app.add_view(views.BlacklistModelView(mongo_configs.Blacklist, 'Apps Blacklist', 'Other'))
admin_app.add_view(views.AdministrationView(AdminUser, 'Users', 'Other'))
admin_app.add_view(views.HistoryView(History, 'History', 'Other'))
admin_app.add_view(views.SideBySideView(name='Side-by-side', endpoint='sbs', category='Other'))
admin_app.add_view(views.UserInfoView(name='User Info', endpoint='user_info', category='Other'))

admin_app.add_view(views.WallpapersView(
    WallpaperCategories, name='Wallpapers', endpoint='wallpapers', category='Resources')
)
admin_app.add_view(views.WallpaperColorsView(
    WallpaperColors, name='Wallpapers colors', endpoint='wallpaper_colors', category='Resources')
)
admin_app.add_view(views.ModelView(
    WallpaperBadges, name='Wallpapers badges', endpoint='wallpaper_badges', category='Resources')
)
admin_app.add_view(views.TranslationsView(
    Translations, name='Update Translations', endpoint='translations', category='Resources'))
admin_app.add_view(views.IconsView(
    Icons, name='Icons', endpoint='icons', category='Resources')
)
admin_app.add_view(views.SimpleThemesView(
    SimpleTheme, name='Simple Themes', endpoint='simple_themes', category='Resources')
)
admin_app.add_view(views.ApkThemesView(
    ApkTheme, name='APK Themes', endpoint='apk_themes', category='Resources')
)

admin_app.add_view(views.MusicWallpapersView(
    MusicWallpapers, name='Music Wallpapers', endpoint='music_wallpapers', category='Resources')
)

admin_app.add_view(views.SettingsPromoBlockView(
    SettingsPromoBlock, name='Settings promo block', endpoint='settings_promo_block', category='Other'))
