from uuid import UUID

from wtforms.validators import ValidationError


class UUIDValidator(object):
    """
    Validates a UUID.

    :param message:
        Error message to raise in case of a validation error.
    """

    def __init__(self, message=None):
        self.message = message

    def __call__(self, form, field, message=None):
        try:
            UUID(field.data)
        except (TypeError, ValueError):
            message = self.message or field.gettext('Invalid UUID.')
            raise ValidationError(message)


class ListUniqueValidator(object):
    def __init__(self, message=None):
        self.message = message

    def __call__(self, form, field, message=None):
        print field.data, form
        if len(field.data) != len(set(field.data)):
            message = self.message or field.gettext('List has duplicate items.')
            raise ValidationError(message)
