from flask_admin.model.template import macro

from jafar.admin.models.base import ROLE_ADMIN, ROLE_DEVELOPER, ROLE_RESOURCE
from jafar.admin.models.icons import Icons
from jafar.admin.views.base import ModelView, get_s3_image_subdocument_config


class IconsView(ModelView):
    access_roles = ROLE_DEVELOPER, ROLE_ADMIN, ROLE_RESOURCE

    form_widget_args = {
        'updated_at': {'readonly': True}
    }

    form_subdocuments = {
        dpi: get_s3_image_subdocument_config('icons')
        for dpi in Icons.DPI
    }

    column_list = ('package_name', 'pack', 'activity', 'clid1', 'language') + tuple(Icons.DPI)
    column_searchable_list = ('package_name', 'activity')
    column_filters = ('package_name', 'activity', 'pack')

    column_formatters = {
        dpi: macro('render_s3_image')
        for dpi in Icons.DPI
    }
