# -*- coding: utf-8 -*-
import logging

from flask_admin.model.fields import AjaxSelectField
from flask_admin.model.template import macro

from jafar.admin.ajax import TranslationsAjaxLoader
from jafar.admin.fields import ColorField
from jafar.admin.models.base import ROLE_ADMIN, ROLE_DEVELOPER, ROLE_RESOURCE
from jafar.admin.views.base import ModelView, get_s3_image_subdocument_config

logger = logging.getLogger()

loader = TranslationsAjaxLoader('title')


class ThemesView(ModelView):
    access_roles = ROLE_DEVELOPER, ROLE_ADMIN, ROLE_RESOURCE

    can_copy = False
    page_size = 15
    can_set_page_size = True

    form_ajax_refs = {
        'title': loader
    }

    form_widget_args = {
        'updated_at': {'readonly': True}
    }

    screens_subdocuments = {
        'form_subdocuments': {
            None: get_s3_image_subdocument_config('themes/screens')
        }
    }


class SimpleThemesView(ThemesView):
    column_list = ('title', 'theme_id')

    form_subdocuments = {
        'screens': ThemesView.screens_subdocuments,
    }

    form_extra_fields = {
        'title': AjaxSelectField(loader, allow_blank=True),
    }


class ApkThemesView(ThemesView):
    column_list = ('theme_id', 'title', 'preview_image')

    form_subdocuments = {
        'screens': ThemesView.screens_subdocuments,
        'preview_image': get_s3_image_subdocument_config('themes/preview')
    }

    form_extra_fields = {
        'title': AjaxSelectField(loader, allow_blank=True),
        'preview_text_color': ColorField(),
        'preview_background_color': ColorField()
    }

    column_formatters = {
        'preview_image': macro('render_s3_image')
    }
