from jafar import mongo_configs
from jafar.arranger.strategy import ArrangerStrategy
from jafar.feed import schema
from jafar.feed.views import BaseJafarView
from jafar.web import JsonResponse


class ArrangerView(BaseJafarView):
    experiment_config = mongo_configs.ArrangerExperimentConfig
    request_schema = schema.ArrangerSchema

    def post(self, request_params, experiment_name):
        config = self.get_experiment_config(experiment_name)
        strategy = ArrangerStrategy(config=config, user=request_params)
        arrangement = strategy.get_arrangement()
        response, errors = schema.ArrangementSchema().dump(arrangement)
        return JsonResponse(response)
