import logging
from datetime import datetime, timedelta

import yt.wrapper as yt
from flask import current_app as app
from flask_script import Command, Option
from yt.wrapper import YtHttpResponseError

logger = logging.getLogger(__name__)


class CleanYT(Command):
    option_list = (
        Option('--days', help='How old should be file to be deleted', default=30),
        Option('--root-path', help='Root path to cleanup', default=None)
    )

    def run(self, days, root_path):
        path = root_path or app.config['YT_PATH_TMP']
        yt.update_config(app.config['YT_CONFIG'])
        self.days = int(days)
        self.cleanup(path)

    def cleanup(self, path):
        try:
            if yt.get_attribute(path, 'type') == 'map_node':
                children = yt.list(path, absolute=True)
                for c in children:
                    self.cleanup(c)

            modification_time = yt.get(path, attributes=['modification_time']).attributes['modification_time']

            if str(modification_time) < (datetime.utcnow() - timedelta(days=self.days)).isoformat():
                yt.remove(path, recursive=True)
                logger.info('Deleted node %s', path)
        except YtHttpResponseError:
            logger.exception('Could not delete node %s', path)
