from flask_script import Command

from pymongo.errors import OperationFailure
from mongoengine.errors import OperationError
from mongoengine.base.common import _document_registry

from jafar.feed.backend import FeedMongoBackend

import logging

logger = logging.getLogger(__name__)


class EnsureIndexes(Command):

    def run(self):
        logger.info("Creating indices for mongo collections")
        FeedMongoBackend.create_indexes()

        # iterate through mongo engine models and avoid creating indexes for the same collection more than once
        processed_collections = set()
        for model in _document_registry.itervalues():
            collection = model._get_collection_name()
            if collection and collection not in processed_collections:
                processed_collections.add(collection)
                try:
                    model.ensure_indexes()
                except (OperationError, OperationFailure), e:
                    logger.error("Failed to create index for %s collection %s", collection, e)
