from flask_script import Command, Option

import logging

from uuid import UUID
from jafar import advisor_mongo, advisor_replica_mongo

logger = logging.getLogger(__name__)


class MigrateUser(Command):
    """
    Loads user profile from production replica and
    inserts it into testing database. This is used
    to troubleshoot users from production.
    """
    option_list = (
        Option('--uuid', dest='uuid', default=None, action='store', type=UUID, required=False),
        Option('--device_id', dest='device_id', default=None, action='store', type=UUID, required=False)
    )

    def run(self, uuid, device_id):
        if not uuid and not device_id:
            raise ValueError('Either --uuid or --device_id params must be present')
        if not device_id:
            logger.debug('Fetching device_id via uuid %s', uuid)
            client = advisor_replica_mongo.db['client'].find_one({'_id': uuid})
            if not client:
                raise ValueError('UUID {} not found'.format(uuid))
            device_id = client['device_id']
            logger.debug('Found device_id %s', device_id)
        if advisor_mongo.db.profile.find_one({'_id': device_id}):
            raise ValueError('User {} is already present in advisor_shard_mongo database'.format(device_id))
        profile = advisor_replica_mongo.db.profile.find_one({'_id': device_id})
        if not profile:
            raise ValueError('Device id {} not found'.format(device_id))
        advisor_mongo.db.profile.insert_one(profile)
